<?php

namespace Drupal\monarch_virtual_field;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;

/**
 * VirtualFieldWidget plugin manager.
 */
class VirtualFieldWidgetPluginManager extends DefaultPluginManager {

  /**
   * Constructs VirtualFieldWidgetPluginManager object.
   *
   * @param \Traversable $namespaces
   *   An object that implements \Traversable which contains the root paths
   *   keyed by the corresponding namespace to look for plugin implementations.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cache_backend
   *   Cache backend instance to use.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module handler to invoke the alter hook with.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct(
      'Plugin/Field/FieldWidget',
      $namespaces,
      $module_handler,
      'Drupal\monarch_virtual_field\VirtualFieldWidgetInterface',
      'Drupal\monarch_virtual_field\Annotation\VirtualFieldWidget'
    );
    $this->alterInfo('virtual_field_widget_info');
    $this->setCacheBackend($cache_backend, 'virtual_field_widget_plugins');
  }

}
