<?php

namespace Drupal\monarch_virtual_field;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Entity\Display\EntityViewDisplayInterface;

/**
 * Interface for virtual_field_formatter plugins.
 */
interface VirtualFieldFormatterInterface {

  /**
   * Returns the translated plugin label.
   *
   * @return string
   *   The translated title.
   */
  public function label();

  /**
   * Returns the label display type.
   *
   * @return string
   *   The label display type.
   */
  public function labelDisplay();

  /**
   * If the plugin applies to a particular entity and bundle.
   *
   * @param string $entity_type_id
   *   The entity type being checked.
   * @param string $bundle
   *   The bundle of the entity type being checked.
   */
  public function appliesTo(string $entity_type_id, string $bundle);

  /**
   * Build the render array content to display this field.
   *
   * @param \Drupal\Core\Entity\ContentEntityInterface $entity
   *   The entity to render this field for.
   * @param \Drupal\Core\Entity\Display\EntityViewDisplayInterface $display
   *   The display used to render this entity.
   * @param mixed $view_mode
   *   The view mode being rendered.
   */
  public function build(ContentEntityInterface $entity, EntityViewDisplayInterface $display, $view_mode) : ?array;

  /**
   * Build the render array to display this field.
   *
   * @param \Drupal\Core\Entity\ContentEntityInterface $entity
   *   The entity to render this field for.
   * @param \Drupal\Core\Entity\Display\EntityViewDisplayInterface $display
   *   The display used to render this entity.
   * @param mixed $view_mode
   *   The view mode being rendered.
   */
  public function buildField(ContentEntityInterface $entity, EntityViewDisplayInterface $display, $view_mode) : ?array;

}
