<?php

namespace Drupal\monarch_virtual_field;

use Drupal\Component\Plugin\PluginBase;
use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Entity\Display\EntityViewDisplayInterface;

/**
 * Base class for virtual_field_formatter plugins.
 */
abstract class VirtualFieldFormatterPluginBase extends PluginBase implements VirtualFieldFormatterInterface {

  /**
   * {@inheritdoc}
   */
  public function label() {
    // Cast the label to a string since it is a TranslatableMarkup object.
    return (string) $this->pluginDefinition['label'];
  }

  /**
   * {@inheritdoc}
   */
  public function labelDisplay() {
    return 'hidden';
  }

  /**
   * {@inheritdoc}
   */
  public function appliesTo(string $entity_type_id, string $bundle) {
    return TRUE;
  }

  /**
   * {@inheritdoc}
   */
  public function build(ContentEntityInterface $entity, EntityViewDisplayInterface $display, $view_mode) : ?array {
    return NULL;
  }

  /**
   * {@inheritdoc}
   */
  public function buildField(ContentEntityInterface $entity, EntityViewDisplayInterface $display, $view_mode) : ?array {
    if (!is_null($element = static::build($entity, $display, $view_mode))) {
      return [
        '#theme' => 'virtual_field',
        '#definition' => $this->pluginDefinition,
        '#field_name' => $this->pluginDefinition['id'],
        '#label_display' => static::labelDisplay(),
        '#title' => static::label(),
        '#content' => $element,
      ];
    }

    return NULL;
  }

}
