<?php

namespace Drupal\monarch_virtual_field;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Form\FormStateInterface;

/**
 * Interface for virtual_field_widget plugins.
 */
interface VirtualFieldWidgetInterface {

  /**
   * Returns the translated plugin label.
   *
   * @return string
   *   The translated title.
   */
  public function label();

  /**
   * If the plugin applies to a particular entity and bundle.
   *
   * @param string $entity_type_id
   *   The entity type being checked.
   * @param string $bundle
   *   The bundle of the entity type being checked.
   */
  public function appliesTo(string $entity_type_id, string $bundle);

  /**
   * Build the render array content to display this field.
   *
   * @param \Drupal\Core\Entity\ContentEntityInterface $entity
   *   The entity to render this field for.
   * @param array $form
   *   The form this widget is being rendered to.
   * @param \Drupal\Core\Form\FormStateInterface $form_state
   *   The display used to render this entity.
   * @param mixed $form_id
   *   The id of the form.
   */
  public function build(ContentEntityInterface $entity, array &$form, FormStateInterface $form_state, $form_id) : ?array;

  /**
   * Build the render array to display this field.
   *
   * This is intended to render the field wrapper as well.
   *
   * @param \Drupal\Core\Entity\ContentEntityInterface $entity
   *   The entity to render this field for.
   * @param array $form
   *   The form this widget is being rendered to.
   * @param \Drupal\Core\Form\FormStateInterface $form_state
   *   The display used to render this entity.
   * @param mixed $form_id
   *   The id of the form.
   */
  public function buildField(ContentEntityInterface $entity, array &$form, FormStateInterface $form_state, $form_id);

  /**
   * Validate handler.
   */
  public function validateField(array $form, FormStateInterface $form_state) : void;

  /**
   * Use the validate handler to validate the data and use the data.
   *
   * This should suffice for a submit handler.
   *
   * @param mixed $values
   *   The values submitted for this field.
   * @param \Drupal\Core\Entity\ContentEntityInterface $entity
   *   The entity this widget is attached to.
   * @param array $element
   *   The element for this widget.
   * @param array $form
   *   The form.
   * @param \Drupal\Core\Form\FormStateInterface $form_state
   *   The form state.
   */
  public function validate($values, ContentEntityInterface $entity, array $element, array $form, FormStateInterface $form_state) : void;

}
